<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Help-Settings-Schema"
                              xmlns:wwhsettings="urn:WebWorks-Help-Settings-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwtoc wwlinks wwmode wwfiles wwdoc wwsplits wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="wwhsettings" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <xsl:variable name="GlobalSettingsTemplatePath">
  <xsl:variable name="VarSkinURISetting" select="concat('wwformat:Skins/', wwprojext:GetFormatSetting('wwhelp-skin', 'Lobby_Blue'), '/wwhelp_settings.xml')" />
  <xsl:value-of select="wwuri:AsFilePath($VarSkinURISetting)" />
 </xsl:variable>


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Groups -->
   <!--        -->
   <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
   <xsl:variable name="VarIgnore1Start" select="wwprogress:Start(count($VarProjectGroups) + 1)" />

   <xsl:for-each select="$VarProjectGroups">
    <xsl:variable name="VarProjectGroup" select="." />

    <xsl:variable name="VarIgnore2Start" select="wwprogress:Start(1)" />

    <!-- Determine group output directory path -->
    <!--                                       -->
    <xsl:variable name="VarGroupOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), $VarProjectGroup/@Name)" />

    <xsl:variable name="VarPath" select="wwfilesystem:Combine($VarGroupOutputDirectoryPath, 'wwhelp/settings.xml')" />

    <!-- Transform -->
    <!--           -->
    <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPath, wwprojext:GetConfigurationChangeID(), $VarProjectGroup/@GroupID, '', $GlobalActionChecksum)" />
    <xsl:if test="not($VarUpToDate)">
     <xsl:variable name="VarResultAsXML">
      <xsl:variable name="VarSettingsTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalSettingsTemplatePath)" />

      <xsl:call-template name="Settings">
       <xsl:with-param name="ParamSettingsTemplate" select="$VarSettingsTemplate" />
       <xsl:with-param name="ParamProjectGroup" select="$VarProjectGroup" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
     <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarPath, 'utf-8', 'xml', '1.0', 'yes')" />
    </xsl:if>

    <!-- Report Files -->
    <!--              -->
    <wwfiles:File path="{$VarPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPath)}" projectchecksum="{wwprojext:GetConfigurationChangeID()}" groupID="{$VarProjectGroup/@GroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
     <wwfiles:Depends path="{$GlobalSettingsTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalSettingsTemplatePath)}" groupID="" documentID="" />
    </wwfiles:File>

    <xsl:variable name="VarIgnore2End" select="wwprogress:End()" />
   </xsl:for-each>

   <!-- Merge -->
   <!--       -->
   <xsl:variable name="VarIgnore3Start" select="wwprogress:Start(1)" />
   <xsl:if test="count($GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group) &gt; 1">
    <xsl:variable name="VarPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), 'wwhelp/settings.xml')" />

    <!-- Transform -->
    <!--           -->
    <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPath, wwprojext:GetConfigurationChangeID(), '', '', $GlobalActionChecksum)" />
    <xsl:if test="not($VarUpToDate)">
     <xsl:variable name="VarResult">
      <xsl:variable name="VarSettingsTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalSettingsTemplatePath)" />

      <xsl:call-template name="Settings">
       <xsl:with-param name="ParamSettingsTemplate" select="$VarSettingsTemplate" />
       <xsl:with-param name="ParamProjectGroup" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group[1]" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarWriteResult" select="wwexsldoc:Document(msxsl:node-set($VarResult), $VarPath, 'utf-8', 'xml', '1.0', 'yes')" />
    </xsl:if>

    <!-- Report Files -->
    <!--              -->
    <wwfiles:File path="{$VarPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPath)}" projectchecksum="{wwprojext:GetConfigurationChangeID()}" groupID="" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
     <wwfiles:Depends path="{$GlobalSettingsTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalSettingsTemplatePath)}" groupID="" documentID="" />
    </wwfiles:File>
   </xsl:if>
   <xsl:variable name="VarIgnore3End" select="wwprogress:End()" />

   <xsl:variable name="VarIgnore1End" select="wwprogress:End()" />

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="Settings">
  <xsl:param name="ParamSettingsTemplate" />
  <xsl:param name="ParamProjectGroup" />

  <xsl:apply-templates select="$ParamSettingsTemplate" mode="wwmode:wwhsettings">
   <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template match="/" mode="wwmode:wwhsettings">
  <xsl:param name="ParamProjectGroup" />

  <xsl:apply-templates select="*" mode="wwmode:wwhsettings">
   <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template match="wwhsettings:Cookies" mode="wwmode:wwhsettings">
  <xsl:param name="ParamProjectGroup" />

  <xsl:copy>
   <xsl:copy-of select="@*[(local-name() != 'enable') and (local-name() != 'id')]" />
   <xsl:attribute name="enable">
    <xsl:value-of select="wwprojext:GetFormatSetting('wwhelp-cookies', 'true')" />
   </xsl:attribute>
   <xsl:attribute name="id">
    <xsl:value-of select="$ParamProjectGroup/@GroupID" />
   </xsl:attribute>

   <xsl:apply-templates select="*" mode="wwmode:wwhsettings">
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhsettings:Accessible" mode="wwmode:wwhsettings">
  <xsl:param name="ParamProjectGroup" />

  <xsl:copy>
   <xsl:copy-of select="@*[local-name() != 'value']" />
   <xsl:attribute name="value">
    <xsl:value-of select="wwprojext:GetFormatSetting('wwhelp-accessibility', 'false')" />
   </xsl:attribute>

   <xsl:apply-templates select="*" mode="wwmode:wwhsettings">
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhsettings:SyncContents" mode="wwmode:wwhsettings">
  <xsl:param name="ParamProjectGroup" />

  <xsl:copy>
   <xsl:copy-of select="@*[local-name() != 'enable']" />
   <xsl:attribute name="enable">
    <xsl:value-of select="wwprojext:GetFormatSetting('wwhelp-sync-toc', 'true')" />
   </xsl:attribute>

   <xsl:apply-templates select="*" mode="wwmode:wwhsettings">
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhsettings:Previous" mode="wwmode:wwhsettings">
  <xsl:param name="ParamProjectGroup" />

  <xsl:copy>
   <xsl:copy-of select="@*[local-name() != 'enable']" />
   <xsl:attribute name="enable">
    <xsl:value-of select="wwprojext:GetFormatSetting('wwhelp-previous-next', 'true')" />
   </xsl:attribute>

   <xsl:apply-templates select="*" mode="wwmode:wwhsettings">
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhsettings:Next" mode="wwmode:wwhsettings">
  <xsl:param name="ParamProjectGroup" />

  <xsl:copy>
   <xsl:copy-of select="@*[local-name() != 'enable']" />
   <xsl:attribute name="enable">
    <xsl:value-of select="wwprojext:GetFormatSetting('wwhelp-previous-next', 'true')" />
   </xsl:attribute>

   <xsl:apply-templates select="*" mode="wwmode:wwhsettings">
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhsettings:RelatedTopics" mode="wwmode:wwhsettings">
  <xsl:param name="ParamProjectGroup" />

  <xsl:copy>
   <xsl:copy-of select="@*[(local-name() != 'enableicon') and (local-name() != 'enableinline')]" />
   <xsl:attribute name="enableicon">
    <xsl:value-of select="wwprojext:GetFormatSetting('wwhelp-related-topics-icon', 'true')" />
   </xsl:attribute>
   <xsl:attribute name="enableinline">
    <xsl:value-of select="wwprojext:GetFormatSetting('wwhelp-related-topics-inline', 'true')" />
   </xsl:attribute>

   <xsl:apply-templates select="*" mode="wwmode:wwhsettings">
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhsettings:Email" mode="wwmode:wwhsettings">
  <xsl:param name="ParamProjectGroup" />

  <xsl:variable name="VarEmailAddress" select="wwprojext:GetFormatSetting('company-email', '')" />

  <xsl:copy>
   <xsl:copy-of select="@*[(local-name() != 'enable') and (local-name() != 'address')]" />
   <xsl:attribute name="enable">
    <xsl:value-of select="string-length($VarEmailAddress) &gt; 0" />
   </xsl:attribute>
   <xsl:attribute name="address">
    <xsl:value-of select="$VarEmailAddress" />
   </xsl:attribute>

   <xsl:apply-templates select="*" mode="wwmode:wwhsettings">
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhsettings:Print" mode="wwmode:wwhsettings">
  <xsl:param name="ParamProjectGroup" />

  <xsl:copy>
   <xsl:copy-of select="@*[local-name() != 'enable']" />
   <xsl:attribute name="enable">
    <xsl:value-of select="wwprojext:GetFormatSetting('wwhelp-print', 'true')" />
   </xsl:attribute>

   <xsl:apply-templates select="*" mode="wwmode:wwhsettings">
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhsettings:Bookmark" mode="wwmode:wwhsettings">
  <xsl:param name="ParamProjectGroup" />

  <xsl:copy>
   <xsl:copy-of select="@*[local-name() != 'enable']" />
   <xsl:attribute name="enable">
    <xsl:value-of select="wwprojext:GetFormatSetting('wwhelp-bookmark', 'false')" />
   </xsl:attribute>

   <xsl:apply-templates select="*" mode="wwmode:wwhsettings">
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhsettings:PDF" mode="wwmode:wwhsettings">
  <xsl:param name="ParamProjectGroup" />

  <xsl:copy>
   <xsl:copy-of select="@*[local-name() != 'enable']" />
   <xsl:attribute name="enable">
    <xsl:value-of select="wwprojext:GetFormatSetting('wwhelp-pdf', 'false')" />
   </xsl:attribute>

   <xsl:apply-templates select="*" mode="wwmode:wwhsettings">
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhsettings:Contents[not(ancestor::wwhsettings:JavaScript)]" mode="wwmode:wwhsettings">
  <xsl:param name="ParamProjectGroup" />

  <xsl:copy>
   <xsl:copy-of select="@*[local-name() != 'enable']" />
   <xsl:attribute name="enable">
    <xsl:value-of select="wwprojext:GetFormatSetting('toc-generate', 'true')" />
   </xsl:attribute>

   <xsl:apply-templates select="*" mode="wwmode:wwhsettings">
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhsettings:Index[not(ancestor::wwhsettings:JavaScript)]" mode="wwmode:wwhsettings">
  <xsl:param name="ParamProjectGroup" />

  <xsl:copy>
   <xsl:copy-of select="@*[local-name() != 'enable']" />
   <xsl:attribute name="enable">
    <xsl:value-of select="wwprojext:GetFormatSetting('index-generate', 'true')" />
   </xsl:attribute>

   <xsl:apply-templates select="*" mode="wwmode:wwhsettings">
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhsettings:Search[not(ancestor::wwhsettings:JavaScript)]" mode="wwmode:wwhsettings">
  <xsl:param name="ParamProjectGroup" />

  <xsl:copy>
   <xsl:copy-of select="@*[local-name() != 'enable']" />
   <xsl:attribute name="enable">
    <xsl:value-of select="wwprojext:GetFormatSetting('wwhelp-search', 'true')" />
   </xsl:attribute>

   <xsl:apply-templates select="*" mode="wwmode:wwhsettings">
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhsettings:Favorites[not(ancestor::wwhsettings:JavaScript)]" mode="wwmode:wwhsettings">
  <xsl:param name="ParamProjectGroup" />

  <xsl:copy>
   <xsl:copy-of select="@*[local-name() != 'enable']" />
   <xsl:attribute name="enable">
    <xsl:value-of select="wwprojext:GetFormatSetting('wwhelp-favorites', 'true')" />
   </xsl:attribute>

   <xsl:apply-templates select="*" mode="wwmode:wwhsettings">
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>


 <xsl:template match="wwhsettings:*" mode="wwmode:wwhsettings">
  <xsl:param name="ParamProjectGroup" />

  <xsl:copy>
   <xsl:copy-of select="@*" />

   <xsl:apply-templates select="*" mode="wwmode:wwhsettings">
    <xsl:with-param name="ParamProjectGroup" select="$ParamProjectGroup" />
   </xsl:apply-templates>
  </xsl:copy>
 </xsl:template>
</xsl:stylesheet>
